/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.sql.SQLException;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;

import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.JapanHolidayUtility;
import jp.mosp.common.action.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.VoInterface;

import jp.mosp.human.dto.MKihonDto;

import jp.mosp.kintai.dao.CmRotationDao;
import jp.mosp.kintai.dao.MScheduleDao;
import jp.mosp.kintai.dao.MSyukkinboDao;
import jp.mosp.kintai.dto.CmRotationDto;
import jp.mosp.kintai.dto.MScheduleDto;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.vo.AttendanceMenuVo;
import jp.mosp.kintai.vo.ScheduleMenuVo;

import jp.mosp.payroll.dto.CompileAmendmentDto;
import jp.mosp.payroll.dto.MKintaiDto;

import jp.mosp.system.dto.MWorkTypeDto;
import jp.mosp.system.dto.MYakusyokuDto;

public abstract class AttendanceTotalAction extends MosPAction {

	// tB[h
	protected String	startDate;
	protected String	endDate;

	protected int 		autoCalc		= 0;
	protected int		lateNightStart 	= 0;
	protected int		lateNightEnd 	= 0;
	protected int		startTime		= 0;
	protected int		quitTime 		= 0;
	protected int		workTime 		= 0;
	protected int		breakTime 		= 0;
	protected int		overStart	 	= 0;
	protected int		overBreak	 	= 0;
	protected int		allHoliday	 	= 0;
	protected int		halfHoliday	 	= 0;

	protected int		late = 0;
	protected int		work = 0;
	protected int		leave = 0;
	protected int		over = 0;
	protected int		interval = 0;
	protected int		latenight = 0;
	protected int		holidaywork = 0;

	protected int		holidayTime 	= 0;
	protected int		inputUnit 		= 1;

	protected boolean isAutoCalc;

	protected double	hoursPerDay		= 0;
	protected double	prescribedDays	= 0;
	protected double	prescribedHours	= 0;

	protected List<MSyukkinboDto>	attendanceList;
	protected List<MScheduleDto> 	scheduleList;

	// Xg
	protected Map<String, MWorkTypeDto> workTypeMap;

	protected String[][] aryHolidayReason;
	protected String[][] aryApprovalReason;

	// Wvf[^
	protected String[][] aryAttendance;
	// Wvf[^
	protected String[][] aryAttendanceCompile;

	/*						
	 *  	2009/04/21	m.yoshida	ǉ
	 */
	protected MScheduleDao 	scheduleDao;
	protected MSyukkinboDao 	syukkinboDao;

	/**
	 * \pDAO
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @throws Exception
	 */
	protected void prepareMScheduleDao() throws Exception {
		// DAO
		if (scheduleDao !=null) {
			return;
		}
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		scheduleDao = new MScheduleDao();
		scheduleDao.initDao(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * oΕpDAO
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @throws Exception
	 */
	protected void prepareMSyukkinboDao() throws Exception {
		// DAO
		if (syukkinboDao !=null) {
			return;
		}
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		syukkinboDao = new MSyukkinboDao();
		syukkinboDao.initDao(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * \Ώۓ擾
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kcode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return dto ΏDTO
	 * @throws Exception
	 */
	protected MScheduleDto getScheduleInfo(String kcode, String targetDate) throws Exception {
		// \pDAO
		prepareMScheduleDao();
		MScheduleDto dto = scheduleDao.findForKey(kcode, targetDate);
		return dto;
	}

	/**
	 * \Ώۓ擾
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kcode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return dto ΏDTO
	 * @throws Exception
	 */
	protected MScheduleDto getScheduleInfo(String kcode, Date targetDate) throws Exception {
		// \pDAO
		prepareMScheduleDao();
		MScheduleDto dto = scheduleDao.findForKey(kcode, util.convDateFormatted(targetDate));
		return dto;
	}

	/**
	 * \ΏۓsbN
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param dto		ΏDTO
	 * @throws Exception
	 */
	protected void lockScheduleInfo(MScheduleDto dto) throws Exception {
		// \pDAO
		prepareMScheduleDao();
		scheduleDao.findForUpdate(dto.getKCode(), dto.getHizuke());
	}

	/**
	 * oΕΏۓ擾
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kcode			ΏێЈR[h
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @return dto ΏDTO
	 * @throws Exception
	 */
	protected MSyukkinboDto getSyukkinboInfo(String kcode, String targetDate) throws Exception {
		// oΕpDAO
		prepareMSyukkinboDao();
		MSyukkinboDto dto = syukkinboDao.findForKey(kcode, targetDate);
		return dto;
	}

	/**
	 * oΕΏۓ擾
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kcode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return dto ΏDTO
	 * @throws Exception
	 */
	protected MSyukkinboDto getSyukkinboInfo(String kcode, Date targetDate) throws Exception {
		// oΕpDAO
		prepareMSyukkinboDao();
		MSyukkinboDto dto = syukkinboDao.findForKey(kcode, util.convDateFormatted(targetDate));
		return dto;
	}

	/**
	 * oΕΏۓsbN
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param dto		ΏDTO
	 * @throws Exception
	 */
	protected void lockSyukkinboInfo(MSyukkinboDto dto) throws Exception {
		// oΕpDAO
		prepareMSyukkinboDao();
		syukkinboDao.findForUpdate(dto.getKCode(), dto.getHizuke());
	}

	/**
	 * oΕΏۓisbNj擾
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @return dto ΏDTO(sbNς)
	 * @throws Exception
	 */
	protected MSyukkinboDto getSyukkinboInfo(String kCode, String targetDate, boolean isUpdate) throws Exception {
		// oΕpDAO
		prepareMSyukkinboDao();
		if (isUpdate) {
			return syukkinboDao.findForUpdate(kCode, targetDate);
		}
		return getSyukkinboInfo(kCode, targetDate);
	}

	/**
	 * oΕΏۓisbNj擾
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return dto ΏDTO(sbNς)
	 * @throws Exception
	 */
	protected MSyukkinboDto getSyukkinboInfo(String kCode, Date targetDate, boolean isUpdate) throws Exception {
		// oΕpDAO
		prepareMSyukkinboDao();
		if (isUpdate) {
			return syukkinboDao.findForUpdate(kCode, util.convDateFormatted(targetDate));
		}
		return getSyukkinboInfo(kCode, targetDate);
	}

	/**
	 * Αӈꗗf[^
	 * @param kCode		ΏێЈR[h
	 * @throws Exception
	 */
	protected void getAttendanceList(String kCode) throws Exception {
		// oΕpDAO 
		prepareMSyukkinboDao();
		// ꗗ̎擾
		attendanceList	= syukkinboDao.findForAttendanceList(kCode, startDate, endDate);
	}

	/**
	 * Αӌꗗf[^擾
	 * @param kCode       ΏێЈR[h
	 * @param targetMonth Ώی
	 * @throws Exception
	 */
	protected void getAttendanceList(String kCode, Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// ͈͎擾
		startDate = MospUtility.getDateString(getStartDate(targetMonth), CommonConst.FORMAT_DATE);
		endDate   = MospUtility.getDateString(getEndDate(targetMonth), CommonConst.FORMAT_DATE);
		// 
		getAttendanceList(kCode);
	}

	/**
	 * Αӌꗗf[^擾
	 * @param kCode ΏێЈR[h
	 * @param year  Ώ۔N
	 * @param month Ώی
	 * @throws Exception
	 */
	protected void getAttendanceList(String kCode, String year, String month) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// ͈͎擾
		startDate = MospUtility.getDateString(util.getFirstDateOfMonth(year, month), CommonConst.FORMAT_DATE);
		endDate   = MospUtility.getDateString(util.getLastDateOfMonth(year, month), CommonConst.FORMAT_DATE);
		// 
		getAttendanceList(kCode);
	}

	/**
	 * Αӌꗗf[^擾i\pj
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param kCode
	 * @param targetDate
	 * @throws Exception
	 */
	protected void getAttendanceListForView(String kCode, Date targetDate) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// ͈͎擾
		startDate = MospUtility.getDateString(getStartDateForList(targetDate), CommonConst.FORMAT_DATE);
		endDate   = MospUtility.getDateString(getEndDateForList(targetDate), CommonConst.FORMAT_DATE);
		// 
		getAttendanceList(kCode);
	}

	/**
	 * Αӓf[^擾
	 * @param kCode       ΏێЈR[h
	 * @param targetDay Ώۓ
	 * @throws Exception
	 */
	protected void getAttendanceDay(String kCode, Date targetDay) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// ͈͎擾
		String attendanceDate = MospUtility.getDateString(targetDay, CommonConst.FORMAT_DATE);
		// oΕpDAO 
		prepareMSyukkinboDao();
		// ꗗ̎擾
		attendanceList	= syukkinboDao.findForCondition(kCode, attendanceDate);
		// Αӏݒ
		setHours();	
	}

	/**
	 * Wvf[^Ԑݒ
	 * @throws Exception 
	 */
	protected void setHours() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// Αӏݒ
		setCalcParam();
		// JԐݒ
		setPrescribedHours();
		// Ζ`ԃ}X^ݒ
		setWorkTypeMap();
	}

	/**
	 * Wvf[^z쐬
	 * @throws Exception
	 */
	protected void makeAttendanceArray() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		aryAttendance = new String[count][40];
		for (int i = 0; i < aryAttendance.length; i++) {
			for (int j = 0; j < aryAttendance[i].length; j++) {
				aryAttendance[i][j] = "";
			}
		}
		// tݒ
		cal.setTime(MospUtility.getDate(startDate));
		for (int i = 0; i < aryAttendance.length; i++) {
			// tipj
			aryAttendance[i][0] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_DATE);
			// t
			aryAttendance[i][1] = String.valueOf(MospUtility.getMonth(cal.getTime()))
			+ CommonConst.SEPARATOR_DATE
			+ String.valueOf(cal.get(Calendar.DAY_OF_MONTH));
			// j
			aryAttendance[i][2] = getDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
			// lijՓAxj
			StringBuffer remark = new StringBuffer();
			String holidayName = getPublicHolidayName(cal.getTime());
			if (holidayName.length() != 0) {
				remark.append(holidayName);
				remark.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			}
			aryAttendance[i][16] = remark.toString();
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		// f[^̐ݒ
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MSyukkinboDto dto = it.next();
			Date attendanceDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < aryAttendance.length; i++) {
				if (attendanceDate.compareTo(cal.getTime()) == 0) {
					// Ζ`
					String kinmu = "";
					// o΂̏ꍇ
					if (isAvailableWorkType(dto)) {
						kinmu = workTypeMap.get(dto.getKinmu()).getShiftName();
						// oΎ
						aryAttendance[i][4 ] = dto.getSyJikoku();
						// ދΎ
						aryAttendance[i][5 ] = dto.getTaJikoku();
						// Ζ
						aryAttendance[i][6 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
						// xe
						aryAttendance[i][7 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
						// x
						aryAttendance[i][8 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getTiJikan()));
						// ގ
						aryAttendance[i][9 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getSoJikan()));
						// cƎ
						aryAttendance[i][10] = getHourString(util.convIntegerTimeToDoubleTime(dto.getZaJikan()));
						// xo
						aryAttendance[i][11] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKsJikan()));
						// [鎞
						aryAttendance[i][12] = getHourString(util.convIntegerTimeToDoubleTime(dto.getSnJikan()));
					} else if (isWeekHoliday(dto)) {
						kinmu = CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY;
					} else {
						for (int k = 0; k < aryHolidayReason.length; k++) {
							if (aryHolidayReason[k][0].equals(dto.getKKRiyuu())) {
								kinmu = aryHolidayReason[k][1];
							}
						}
					}
					aryAttendance[i][3 ] = kinmu;
					// ꎟFA񎟏F
					String[] result = setApproval(dto.getSnRiyuu());
					aryAttendance[i][13] = result[0];
					aryAttendance[i][14] = result[1];
					// 蓖
					StringBuffer sb = new StringBuffer();
					sb.append(dto.getSyokuji());
					sb.append(CommonConst.SEPARATOR_DATE);
					sb.append(dto.getCyoku1());
					sb.append(dto.getCyoku2());
					sb.append(dto.getCyoku3());
					sb.append(CommonConst.SEPARATOR_DATE);
					sb.append(dto.getHoka1());
					sb.append(dto.getHoka2());
					sb.append(dto.getHoka3());
					sb.append(dto.getHoka4());
					sb.append(dto.getHoka5());
					aryAttendance[i][15] = sb.toString();
					// x
					if (isQuitHalfHoliday(dto) || isQuitHalfHoliday(dto)) {
						aryAttendance[i][16] += CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.NAM_COMMON_HALF_KANA_SPACE;
					}
					if (isWorkOnHoliday(dto)) {
						aryAttendance[i][16] += CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_HALF_KANA_SPACE;		
					}
					break;
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
	}

	/**
	 * Wv
	 * @throws Exception 
	 */
	protected void totalAttendanceDaily() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z̏
		aryAttendanceCompile = new String[18][2];
		// ϐ錾Aϐ̏
		// ΖԌv
		int totalWork = 0;
		// xeԌv
		int totalInterbal = 0;
		// xԌv
		int totalLate = 0;
		// ގԌv
		int totalLeave = 0;
		// cƎԌv
		int totalOver = 0;
		// xoԌv
		int totalHolidayWork = 0;
		// [鎞Ԍv
		int totalLateNight = 0;
		// oΓv
		int totalWorkDays = 0;
		// Lxv
		double totalPaidHoliday = 0;
		// ʋxɌv
		int totalParticularHoliday = 0;
		// Γv
		int totalAbsence = 0;
		// axɌv
		int totalMedicalLeave = 0;
		// xv
		int totalCompensationDay =0;
		// U֋xɌv
		int totalTransfer = 0;
		// xɌv
		int totalOther = 0;
		// xސ
		int leaveAndLate = 0;
		// 蓖
		int syokuji = 0;
		int cyoku1 = 0;
		int cyoku2 = 0;
		int cyoku3 = 0;
		int hoka1 = 0;
		int hoka2 = 0;
		int hoka3 = 0;
		int hoka4 = 0;
		int hoka5 = 0;
		// Wvf[^擾
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		// WvJn
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MSyukkinboDto dto = it.next();
			Date attendanceDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < count; i++) {
				if (attendanceDate.compareTo(cal.getTime()) == 0) {
					// ΑӍ
					if (isAvailableWorkType(dto)) {
						// Ζ
						totalWork += dto.getKinmuJi();
						// xe
						totalInterbal += dto.getKyukeiJi();
						// x
						totalLate += dto.getTiJikan();
						// ގ
						totalLeave += dto.getSoJikan();
						// cƎ
						totalOver += dto.getZaJikan();
						// xo
						totalHolidayWork += dto.getKsJikan();
						// [鎞
						totalLateNight += dto.getSnJikan();
						// oΓ
						if (dto.getKinmuJi() > 0) {
							totalWorkDays++;
						}
						// xސ
						if (dto.getTiJikan() > 0 || dto.getSoJikan() > 0) {
							leaveAndLate++;
						}
						// 蓖
						syokuji += dto.getSyokuji();
						cyoku1 	+= dto.getCyoku1();
						cyoku2 	+= dto.getCyoku2();
						cyoku3 	+= dto.getCyoku3();
						hoka1 	+= dto.getHoka1();
						hoka2 	+= dto.getHoka2();
						hoka3 	+= dto.getHoka3();
						hoka4 	+= dto.getHoka4();
						hoka5 	+= dto.getHoka5();
						// x
						if (isQuitHalfHoliday(dto) || isQuitHalfHoliday(dto)) {
							totalPaidHoliday += 0.5;
						}
					} else {
						// xɍ
						if (!dto.getKKRiyuu().equals("")) {
							if (dto.getKKRiyuu().equals(aryHolidayReason[0][0])) {
								// LxɁim_code, xɗR, tcode="0"j
								totalPaidHoliday++;
							} else if (dto.getKKRiyuu().equals(aryHolidayReason[1][0])) {
								// ʋxɁim_code, xɗR, tcode="1"j
								totalParticularHoliday++;
							} else if (dto.getKKRiyuu().equals(aryHolidayReason[2][0])) {
								// Γim_code, xɗR, tcode="2"j
								totalAbsence++;
							} else if (dto.getKKRiyuu().equals(aryHolidayReason[3][0])) {
								// axɁim_code, xɗR, tcode="3"j
								totalMedicalLeave++;
							} else if (dto.getKKRiyuu().equals(aryHolidayReason[4][0])) {
								// xim_code, xɗR, tcode="4"j
								totalCompensationDay++;
							} else if (dto.getKKRiyuu().equals(aryHolidayReason[5][0])) {
								// U֋xɁim_code, xɗR, tcode="5"j
								totalTransfer++;
							} else {
								// xɁim_code, xɗR, tcode="6"j
								totalOther++;
							}
						}
					}
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
		// z
		// Ζԍv
		aryAttendanceCompile[0][0] = CommonConst.NAM_WORKING;
		aryAttendanceCompile[0][1] = getHourString(util.convIntegerTimeToDoubleTime(totalWork));
		// xeԍv
		aryAttendanceCompile[1][0] = CommonConst.NAM_INTERVAL_TIME;
		aryAttendanceCompile[1][1] = getHourString(util.convIntegerTimeToDoubleTime(totalInterbal));
		// xԍv
		aryAttendanceCompile[2][0] = CommonConst.NAM_ARRIVE_LATE;
		aryAttendanceCompile[2][1] = getHourString(util.convIntegerTimeToDoubleTime(totalLate));
		// ގԍv
		aryAttendanceCompile[3][0] = CommonConst.NAM_LEAVE_EARLY;
		aryAttendanceCompile[3][1] = getHourString(util.convIntegerTimeToDoubleTime(totalLeave));
		// cƎԍv
		aryAttendanceCompile[4][0] = CommonConst.NAM_OVERTIME;
		aryAttendanceCompile[4][1] = getHourString(util.convIntegerTimeToDoubleTime(totalOver));
		// xoԍv
		aryAttendanceCompile[5][0] = CommonConst.NAM_WORK_ON_HOLIDAY;
		aryAttendanceCompile[5][1] = getHourString(util.convIntegerTimeToDoubleTime(totalHolidayWork));
		// [鎞ԍv
		aryAttendanceCompile[6][0] = CommonConst.NAM_LATE_NIGHT;
		aryAttendanceCompile[6][1] = getHourString(util.convIntegerTimeToDoubleTime(totalLateNight));
		// oΓ
		aryAttendanceCompile[7][0] = CommonConst.NAM_PRESENCE;
		aryAttendanceCompile[7][1] = String.valueOf(totalWorkDays);
		// Lxɓ
		aryAttendanceCompile[8][0] = aryHolidayReason[0][1];
		aryAttendanceCompile[8][1] = String.valueOf(totalPaidHoliday);
		// ʋxɓ
		aryAttendanceCompile[9][0] = aryHolidayReason[1][1];
		aryAttendanceCompile[9][1] = String.valueOf(totalParticularHoliday);
		// ΋xɓ
		aryAttendanceCompile[10][0] = aryHolidayReason[2][1];
		aryAttendanceCompile[10][1] = String.valueOf(totalAbsence);
		// axɓ
		aryAttendanceCompile[11][0] = aryHolidayReason[3][1];
		aryAttendanceCompile[11][1] = String.valueOf(totalMedicalLeave);
		// x
		aryAttendanceCompile[12][0] = aryHolidayReason[4][1];
		aryAttendanceCompile[12][1] = String.valueOf(totalCompensationDay);
		// U֋xɓ
		aryAttendanceCompile[13][0] = aryHolidayReason[5][1];
		aryAttendanceCompile[13][1] = String.valueOf(totalTransfer);
		// xɓ
		aryAttendanceCompile[14][0] = CommonConst.NAM_OTHER_SHORT;
		aryAttendanceCompile[14][1] = String.valueOf(totalOther);
		// xސ
		aryAttendanceCompile[15][0] = CommonConst.NAM_LATE_AND_LEAVE_EARLY;
		aryAttendanceCompile[15][1] = String.valueOf(leaveAndLate);
		// 蓖
		StringBuffer allowance = new StringBuffer();
		allowance.append(syokuji);
		allowance.append(CommonConst.SEPARATOR_DATE);
		allowance.append(cyoku1);
		allowance.append(cyoku2);
		allowance.append(cyoku3);
		allowance.append(CommonConst.SEPARATOR_DATE);
		allowance.append(hoka1);
		allowance.append(hoka2);
		allowance.append(hoka3);
		allowance.append(hoka4);
		allowance.append(hoka5);
		aryAttendanceCompile[16][0] = CommonConst.NAM_ALLOWANCE;
		aryAttendanceCompile[16][1] = allowance.toString();
		// F΁i΁AʋxɁAaAxސ̍vj
		if ((totalAbsence + totalParticularHoliday + totalMedicalLeave + leaveAndLate) == 0
				&& totalWorkDays != 0) {
			aryAttendanceCompile[17][0] = CommonConst.NAM_PERFECT_ATTENDANCE;
			aryAttendanceCompile[17][1] = CommonConst.NAM_PERFECT_ATTENDANCE;
		} else {
			aryAttendanceCompile[17][0] = CommonConst.NAM_PERFECT_ATTENDANCE;
			aryAttendanceCompile[17][1] = "";			
		}
	}

	/**
	 * `ԃ}X^ݒ
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 */
	protected void setWorkTypeMap() throws ClassNotFoundException, SQLException, IllegalAccessException, NoSuchFieldException {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// 擾ϊmF
		if (workTypeMap != null) {
			return;
		}
		// Map̍쐬
		workTypeMap = getWorkTypeMap();
	}

	/**
	 * 1JԎ擾
	 * @throws Exception 
	 */
	protected void setPrescribedHours() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// 擾ϊmF
		if (hoursPerDay != 0) {
			return;
		}
		// M_CODEl擾
		String[] aryConf = getMosPCode(CommonConst.TID_STATUTORY, CommonConst.TCD_STATUTORY_HOUR);
		// l̐ݒ
		hoursPerDay = Double.parseDouble(aryConf[2]);
	}

	/**
	 * [鎞Ԏ擾
	 * @throws Exception 
	 */
	private void setLateNightTime() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// 擾ϊmF
		if (lateNightStart != 0) {
			return;
		}
		// M_CODEl擾
		String[] aryConf = getMosPCode(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_LATE_NIGHT);
		// l̐ݒ
		lateNightStart = Integer.parseInt(aryConf[2].substring(0, 2)) * 60 
		+ Integer.parseInt(aryConf[2].substring(3, 5));
		lateNightEnd   = lateNightStart 
		+ Integer.parseInt(aryConf[2].substring(6, 8)) * 60
		+ Integer.parseInt(aryConf[2].substring(9, 11));
	}

	/**
	 * ԏJEԎ擾
	 * @throws Exception 
	 */
	private void setPrescribedCalendar() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// 擾ϊmF
		if (prescribedDays != 0) {
			return;
		}
		if (prescribedHours != 0) {
			return;
		}
		// ԏJ
		String[] aryConfDays = getMosPCode(CommonConst.TID_STATUTORY_MONTH, CommonConst.TCD_STATUTORY_DAYS);
		prescribedDays = Double.parseDouble(aryConfDays[2]);
		// ԏJԐ
		String[] aryConfHours = getMosPCode(CommonConst.TID_STATUTORY_MONTH, CommonConst.TCD_STATUTORY_HOUR);
		prescribedHours = Double.parseDouble(aryConfHours[2]);
	}

	/**
	 * vZtO擾
	 * @throws Exception
	 */
	private void setAutoCalc() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// vZtO擾
		String[] aryAutoCalc = getMosPCode(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_AUTOMATIC_CALCULATION);
		autoCalc = Integer.parseInt(aryAutoCalc[2]);
		if (autoCalc == 0) {
			isAutoCalc = true;
		} else {
			isAutoCalc = false;
		}
	}

	/**
	 * xɎԎ擾
	 * @throws Exception
	 */
	private void setHolidayTimes() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		String[] aryHolidayTimes = getMosPCode(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_HOLIDAY_HOURS);
		allHoliday = Integer.parseInt(aryHolidayTimes[2].substring(0, 2)) * 60 
		+ Integer.parseInt(aryHolidayTimes[2].substring(3, 5));
		halfHoliday = Integer.parseInt(aryHolidayTimes[2].substring(6, 8)) * 60 
		+ Integer.parseInt(aryHolidayTimes[2].substring(9, 11));
	}

	/**
	 * Ζ`ԕʏݒ
	 * @param shiftcode
	 * @throws Exception
	 */
	protected void getWorkTypeInfo(String shiftcode) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// Ζ`ԏ擾
		MWorkTypeDto dto = workTypeMap.get(shiftcode);
		startTime 	= dto.getStartTime();
		quitTime 	= dto.getQuitTime();
		workTime 	= dto.getWorkTime();
		breakTime	= dto.getBreakTime();
		overStart	= dto.getOverStart();
		overBreak	= dto.getOverBreak();
	}

	/**
	 * Wv{ݒ
	 * @throws Exception
	 */
	protected void setCalcParam() throws Exception {
		// vZݒ
		setAutoCalc();
		// ͒Pʎ
		inputUnit = Integer.parseInt(getMosPCode(CommonConst.TID_INPUT_UNIT_TIMES, CommonConst.TCD_MINUTES)[2]);
		// [鎞Ԑݒ
		setLateNightTime();
		// xɎԐݒ
		setHolidayTimes();
		// ԏJEԐݒ
		setPrescribedCalendar();
		// xɗR
		aryHolidayReason = getMosPCodeArray(CommonConst.TID_LEAVE_REASON);
		// FR
		aryApprovalReason = getMosPCodeArray(CommonConst.TID_APPROVAL_REASON);
	}

	/**
	 * o΍ڂ̌vZ
	 * @param start oΎ(int)
	 * @param isStartHalf oΎx̏ꍇ true
	 * @param isHolidayWork xȍꍇtrue
	 */
	protected void getCalcStartTime(int start, boolean isStartHalf, boolean isHolidayWork) {
		if (isStartHalf | isHolidayWork) {
			late = 0;
		} else {
			late = setLateTimes(start);
		}
	}

	/**
	 * xԌvZ
	 * @param start oΎ
	 * @return	int	x
	 */
	private int setLateTimes(int start) {
		// oΎ - WoΎ
		int latemin = start - startTime;
		// x̂Ƃ͒vZ(PʎԂZ)5̏ꍇvZʂ0ɂȂ̂ōŒłPʎԂƂ
		if ((latemin < inputUnit) && (startTime < start)) {
			latemin = inputUnit;
		}
		if (latemin > 0) {
			// ۂ
			latemin -= latemin%inputUnit;
		}
		if (latemin < 0) {
			latemin = 0;
		}
		return latemin;
	}

	/**
	 * ދ΍ڂ̌vZ
	 * @param start oΎ
	 * @param quit ދΎ
	 * @param isHalf oΎxAދΎx̏ꍇtrue
	 */
	protected void getCalcQuitTime(int start, int quit, boolean isHalf) {
		// Ζ
		work 		= setWorkTimes(start, quit);
		leave 		= setLeaveEarlyTimes(quit);
		if (isHalf) {
			leave = 0;
		}
		over 		= setOverTimes(isHalf);
		interval 	= setIntervalTimes();
		latenight	= setLateNightTimes(quit);
		holidaywork	= setHolidayWork();
	}

	/**
	 * ΖԌvZ
	 * @param start
	 * @param quit
	 * @return	workmin
	 */
	private int setWorkTimes(int start, int quit) {
		// ގЎ - oΎ		
		int workmin = quit - start;
		// ۂ
		workmin -= workmin%inputUnit;
		return workmin;
	}

	/**
	 * ގԌvZ
	 * @return	leavemin
	 */
	private int setLeaveEarlyTimes(int quit) {
		// WގЎ - ގЎ
		int leavemin = quitTime - quit;
		// Ζ < WΖ
		if (work < workTime) {
			// ۂ
			leavemin -= leavemin%inputUnit;
		}
		if (leavemin < 0) {
			leavemin = 0;
		}
		return leavemin;
	}

	/**
	 * cƎԌvZ
	 * @param isHalf oΎxAދΎx̏ꍇtrue
	 * @return	overmin
	 */
	private int setOverTimes(boolean isHalf) {
		// x + Ζ
		int worktimes = late + work;
		// cƎ
		int overmin = 0;
		// x
		if (isHalf) {
			worktimes -= halfHoliday;
		}
		// ΖΏێ > WcƌvZJn
		if (worktimes > overStart) {
			// ΖΏێ - WΖ - cƋxe
			overmin = worktimes - workTime - overBreak;
			if (overmin < 0) {
				overmin = 0;
			}
		}
		return overmin;
	}

	/**
	 * xeԌvZ
	 * @return	intervalmin
	 */
	private int setIntervalTimes() {
		int intervalmin = 0;
		// Wxe  5Ԉȏ
		if (work > 300) {
			intervalmin = breakTime;
		}
		// cƋxe
		if (over > 0) {
			intervalmin += overBreak;
		}
		return intervalmin;
	}

	/**
	 * [鎞ԌvZ
	 * @return	latenightmin
	 */
	private int setLateNightTimes(int quit) {
		// ގЎ - W[Jn
		int latenightmin = quit - lateNightStart;
		// ۂ
		latenightmin -= latenightmin%inputUnit;
		// x
		if (latenightmin > (lateNightEnd - lateNightStart)) {
			latenightmin = lateNightEnd - lateNightStart;
		}
		if (latenightmin < 0) {
			latenightmin = 0;
		}
		return latenightmin;
	}

	/**
	 * xoԌvZ
	 * @return	holiwork
	 */
	private int setHolidayWork() {
		int holiwork = work - interval;
		return holiwork;
	}

	/**
	 * FR\
	 * @param riyuu FR
	 * @return	result
	 */
	protected String[] setApproval(String riyuu) {
		String[] result = new String[2];
		for (int k = 0; k < aryApprovalReason.length; k++) {
			if (isRequest(riyuu)) {
				// \̏ꍇiꎟc\A񎟁c󗓁j
				result[0] = aryApprovalReason[0][1];
				result[1] = "";
			} else if (is1stApproved(riyuu)) {
				// ꎟFς̏ꍇiꎟcFρA񎟐\j
				result[0] = aryApprovalReason[1][1];
				result[1] = aryApprovalReason[0][1];
			} else if (riyuu.equals(CommonConst.NUM_ATTENDANCE_1ST_RETURNED)) {
				// ꎟ߂̏ꍇiꎟc߁A񎟁c󗓁j
				result[0] = aryApprovalReason[2][1];
				result[1] = "";
			} else if (is2ndApproved(riyuu)) {
				// 񎟏Fς̏ꍇiꎟcFρA񎟏Fρj
				result[0] = aryApprovalReason[1][1];
				result[1] = aryApprovalReason[3][1];
			} else if (riyuu.equals(CommonConst.NUM_ATTENDANCE_2ND_RETURNED)) {
				// ꎟ߂̏ꍇiꎟc񎟍߁A񎟁c󗓁j
				result[0] = aryApprovalReason[4][1];
				result[1] = "";
			} else {
				result[0] = "";
				result[1] = "";
			}
		}
		return result;
	}

	/**
	 * Αӌ
	 * @throws Exception
	 */
	protected void searchAttendance() throws Exception {
		// Αӌ
		MSyukkinboDto dto = getSyukkinboInfo(key1, key2);
		if (dto != null) {
			if (!isHoliday(dto)) {
				// oΗLAދΖ
				if (dto.getTaJikoku().equals("") && !isWeekHoliday(dto)) {
					// ދΕ\
					setNextCmd(AttendanceQuitCardAction.CMD_QUIT_CARD_SHOW);
				} else {
					// oΗLAދΗLiTx̏ꍇj
					// mF\
					setNextCmd(AttendanceCheckCardAction.CMD_CHECK_CARD_SELECT);
				}				
			} else {
				// x
				// xɕ\
				setNextCmd(AttendanceHolidayCardAction.CMD_HOLIDAY_CARD_SELECT);		
			}
		} else {
			// oΕ\
			setNextCmd(AttendanceStartCardAction.CMD_START_CARD_SHOW);
		}
		// T[ubg֓]
		setUrl(MospConst.URL_SRV);
	}

	/**
	 * Αӓo^p[^ݒ
	 * @param vo
	 * @throws Exception
	 */
	protected void setAttendanceInfo(AttendanceMenuVo vo) throws Exception {
		// l{擾
		MKihonDto mKihonDto = getBasisInfo(key1);
		// AttendanceMenuVoɒlZbg
		vo.setHidKCode(mKihonDto.getKCode());
		vo.setHidKName(mKihonDto.getSimei());
		vo.setHidYear(String.valueOf(MospUtility.getYear(MospUtility.getDate(key2))));
		vo.setHidMonth(String.valueOf(MospUtility.getMonth(MospUtility.getDate(key2))));
		vo.setHidDay(String.valueOf(MospUtility.getDay(MospUtility.getDate(key2))));
		vo.setHidDate(util.convStringDateFormatted(vo.getHidYear(), vo.getHidMonth(), vo.getHidDay()));
		vo.setHidSelectCmd(cmd);
		vo.setLblKCode(vo.getHidKCode());
		vo.setLblKName(vo.getHidKName());
		vo.setLblYear(vo.getHidYear());
		vo.setLblMonth(vo.getHidMonth());
		vo.setLblDay(vo.getHidDay());
	}

	/**
	 * \[hZbg
	 * <p>[VK]A[XV]A[Fς]</p>
	 * @param vo
	 * @param dto
	 */
	protected void setMode(AttendanceMenuVo vo, MSyukkinboDto dto) throws Exception {
		if (dto == null) {
			vo.setMode(AttendanceMenuVo.MODE_INSERT);
		} else if (isApproved(dto)) {
			vo.setMode(AttendanceMenuVo.MODE_APPROVED);
		} else {
			vo.setMode(AttendanceMenuVo.MODE_EDIT);
		}
	}

	/**
	 * ČpMenuVo̕ۑ
	 * @param vo
	 */
	protected void setStoreAttendanceMenuVo(AttendanceMenuVo vo) {
		// ۑVO̔j
		removeStoredVo(CommonConst.VO_ATTENDANCE_MENU);
		// VO̕ۑ
		storeVo(CommonConst.VO_ATTENDANCE_MENU, vo);
	}

	/**
	 * FEF쐬
	 * @return [0]cFA[1]cFA[2]coΌ
	 * @throws Exception
	 */
	protected int[] makeApprovalNumber() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		int number[] = {0, 0, 0};
		// tݒ
		cal.setTime(MospUtility.getDate(startDate));
		// f[^̐ݒ
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		// oΌ
		number[2] = attendanceList.size();
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MSyukkinboDto dto = it.next();
			Date attendanceDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < count; i++) {
				if (attendanceDate.compareTo(cal.getTime()) == 0) {
					// ꎟFA񎟏F
					if (is2ndApproved(dto)) {
						number[0]++;
					} else {
						number[1]++;
					}
					break;
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
		return number;
	}

	/**
	 * j̎擾
	 * <p>	2009/02/25	m.yoshida	j\bhC </p>
	 * @param targetDate		Ώ۔N
	 * @return	Ώ۔Nj
	 * @throws Exception
	 */
	protected String getPublicHolidayName(Date targetDate) throws Exception {
		String holidayName = "";
		// Ώۓj̎擾
		String targetName = getHolidayMap(MospUtility.getYear(targetDate)).get(targetDate);
		if (targetName != null) {
			holidayName = targetName;
		}
		return holidayName;
	}

	/**
	 * PNjՓz擾
	 * @param year
	 * @return	result
	 */
	private String[][] getAryHolidaySingleYear(int year) {
		JapanHolidayUtility utl = new JapanHolidayUtility(year);
		String[][] result = utl.getArySyuku();
		return result;
	}

	/**
	 * j̃}bv
	 * @param year			Ώ۔N
	 * @throws Exception
	 */
	private Map<Date, String> getHolidayMap(int year) throws Exception {
		Map<Date, String> holidayMap = new TreeMap<Date, String>();
		// jՓAxݒ
		String[][] aryCodeHoliday = getMosPCodeArray(CommonConst.TID_HOLIDAY);
		Date holiday = null;
		for (int k = 0; k < aryCodeHoliday.length; k++) {
			// MM/DDn܂xւ̑Ή
			if (aryCodeHoliday[k][0].startsWith("0")
					|| aryCodeHoliday[k][0].startsWith("1")
			) {
				StringBuffer date = new StringBuffer();
				date.append(String.valueOf(year));
				date.append(CommonConst.SEPARATOR_DATE);
				date.append(aryCodeHoliday[k][0].split(CommonConst.SEPARATOR_DATE)[0]);
				date.append(CommonConst.SEPARATOR_DATE);
				date.append(aryCodeHoliday[k][0].split(CommonConst.SEPARATOR_DATE)[1]);
				holiday = MospUtility.getDate(date.toString());
			} else {
				holiday = MospUtility.getDate(aryCodeHoliday[k][0]);
			}
			holidayMap.put(holiday, aryCodeHoliday[k][1]);
		}
		// nbs[}f[ݒ
		String[][] aryJapanHoliday = getAryHolidaySingleYear(year);
		for (int i = 0; i < aryJapanHoliday.length; i++) {
			holiday = MospUtility.getDate(aryJapanHoliday[i][0]);
			if (holidayMap.get(holiday) == null) {
				holidayMap.put(holiday, aryJapanHoliday[i][1]);
			}
		}
		return holidayMap;
	}

	/**
	 * ΑӈꗗpTu^CgR}h̐ݒ
	 * @param vo	ΏVO
	 */
	protected void setSubTitleMenu(AttendanceMenuVo vo) {
		// ΑӊǗR}h
		if (getStoredVo(CommonConst.VO_EMPLOYEE_ATTENDANCE_LIST) != null) {
			// ԑJڊmF
			vo.setCmdMenuButton(vo.CMD_MENU_MAMAGE);
			vo.setCmdListButton(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
			vo.setNamListButton(CommonConst.TTL_ATTENDANCE_LIST);
		} else {
			vo.setCmdMenuButton(vo.CMD_MENU_INPUT);
			vo.setCmdListButton(vo.CMD_MENU_INPUT);
			vo.setNamListButton(CommonConst.NAM_MENU);			
		}
	}

	/*XPW[֘A*/

	/**
	 * \茎ꗗf[^
	 * @param kCode		ΏێЈR[h
	 * @throws Exception
	 */
	protected void getScheduleList(String kCode) throws Exception {
		// \pDAO 
		prepareMScheduleDao();
		// ꗗ̎擾
		scheduleList = scheduleDao.findForScheduleList(kCode, startDate, endDate);
	}

	/**
	 * \茎ꗗf[^擾
	 * @param kCode       ΏێЈR[h
	 * @param targetMonth Ώی
	 * @throws Exception
	 */
	protected void getScheduleList(String kCode, Date targetMonth) throws Exception {
		// ͈͎擾
		startDate = MospUtility.getDateString(getStartDate(targetMonth), CommonConst.FORMAT_DATE);
		endDate   = MospUtility.getDateString(getEndDate(targetMonth), CommonConst.FORMAT_DATE);
		// 
		getScheduleList(kCode);
	}

	/**
	 * Αӌꗗf[^擾
	 * @param kCode ΏێЈR[h
	 * @param year  Ώ۔N
	 * @param month Ώی
	 * @throws Exception
	 */
	protected void getScheduleList(String kCode, String year, String month) throws Exception {
		// ͈͎擾
		startDate = MospUtility.getDateString(util.getFirstDateOfMonth(year, month), CommonConst.FORMAT_DATE);
		endDate   = MospUtility.getDateString(util.getLastDateOfMonth(year, month), CommonConst.FORMAT_DATE);
		// 
		getScheduleList(kCode);
	}

	/**
	 * \茎ꗗf[^擾i\pj
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param kCode 		ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @throws Exception
	 */
	protected void getScheduleListForView(String kCode, Date targetDate) throws Exception {
		// ͈͎擾
		startDate = MospUtility.getDateString(getStartDateForList(targetDate), CommonConst.FORMAT_DATE);
		endDate   = MospUtility.getDateString(getEndDateForList(targetDate), CommonConst.FORMAT_DATE);
		// 
		getScheduleList(kCode);
	}

	/**
	 * Wvf[^Ԑݒ
	 * @throws Exception 
	 */
	protected void setScheduleHours() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// Αӏݒ
		setHours();
		// Wvf[^擾
		Iterator<MScheduleDto> it = scheduleList.iterator();
		while (it.hasNext()) {
			MScheduleDto dto = it.next();
			if (isHoliday(dto)) {
				// xɂ̏ꍇ
				dto.setKKJikan(allHoliday);
			} else if (isWeekHoliday(dto)) {
				// Tx̏ꍇ
			} else {
				// o΂̏ꍇ
				// 
				late 		= 0;
				work 		= 0;
				leave 		= 0;
				over 		= 0;
				interval 	= 0;
				latenight 	= 0;
				holidaywork = 0;
				// Ζ`ԂK莞擾
				getWorkTypeInfo(dto.getKinmu());
				// oΎZo
				int start = util.convStringTimeToIntegerTime(dto.getSyJikoku());
				// ދΎZo
				int quit = quitTime;
				if (!dto.getTaJikoku().equals("")) {
					quit = util.convStringTimeToIntegerTime(dto.getTaJikoku());
				}
				boolean shankyukbn = isStartHalfHoliday(dto);
				boolean kyusyukbn = isWorkOnHoliday(dto);
				boolean thankyukbn = isQuitHalfHoliday(dto);
				// o΍ڂ̌vZ
				getCalcStartTime(start, shankyukbn, kyusyukbn);
				// xԃZbg
				dto.setTiJikan(late);
				// ދ΍ڂ̌vZ
				getCalcQuitTime(start, quit, (shankyukbn || thankyukbn));
				// ΖԃZbg
				dto.setKinmuJi(work);
				// ގԃZbg
				dto.setSoJikan(leave);
				// cƎԃZbg
				dto.setZaJikan(over);
				// xeԃZbg
				dto.setKyukeiJi(interval);
				// [鎞ԃZbg
				dto.setSnJikan(latenight);
				// xoԃZbg
				if (kyusyukbn) {
					dto.setKsJikan(holidaywork);
				} else {
					dto.setKsJikan(0);
				}
			}
		}
	}

	/*\֘A*/

	/**
	 * IЈl{擾
	 * @param vo
	 * @throws Exception
	 */
	protected void setSelectBasicInfo(ScheduleMenuVo vo) throws Exception {
		// l{̎擾
		MKihonDto mKihonDto = getBasisInfo(vo.getSelectKCode());
		// I̐ݒ
		vo.setSelectKName(mKihonDto.getSimei());
		vo.setSelectSectionName(util.getCodeName(mKihonDto.getSCode(), getSectionArrayAll()));
	}

	/**
	 * \̃Zbg
	 * @param kcode ЈR[h
	 * @param scode R[h
	 * @param Hizuke t
	 * @param workTypeCode Ζ`ԃR[h
	 * @return dto ΏDTO
	 * @throws Exception
	 */
	protected MScheduleDto setScheduleInfo(
			String kcode, 
			String scode, 
			String[] arySchedule
	) throws Exception {
		MScheduleDto dto = new MScheduleDto();
		dto.setKCode(kcode);
		dto.setHizuke(arySchedule[0]);
		dto.setNen(MospUtility.getYear(util.convStringDateToDate(dto.getHizuke())));
		dto.setTuki(MospUtility.getMonth(util.convStringDateToDate(dto.getHizuke())));
		dto.setHi(MospUtility.getDay(util.convStringDateToDate(dto.getHizuke())));
		dto.setSyozoku(scode);
		if (isWeekHoliday(arySchedule[1])) {
			// Tx̏ꍇ
			dto.setKinmu(CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
			dto.setSyJikoku("");
			dto.setTaJikoku("");
			dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
			dto.setUpdtTimes(util.getDateTime(new Date()));
		} else {
			MWorkTypeDto workTypeDto = workTypeMap.get(arySchedule[1]);
			dto.setKinmu(workTypeDto.getShiftCode());
			dto.setSyJikoku(util.convIntegerTimeToStringTime(workTypeDto.getStartTime()));
			dto.setSyTimes(util.getDateTime(new Date()));
			dto.setTaJikoku(util.convIntegerTimeToStringTime(workTypeDto.getQuitTime()));
			dto.setKinmuJi(workTypeDto.getWorkTime());
			dto.setKyukeiJi(workTypeDto.getBreakTime());
			dto.setTaTimes(util.getDateTime(new Date()));
			dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
			dto.setUpdtTimes(util.getDateTime(new Date()));
		}
		return dto;
	}

	/**
	 * oἘo^
	 * @param dto
	 * @throws Exception
	 */
	protected void insert(MSyukkinboDto dto, VoInterface vo) throws Exception {
		// oΕpDAO 
		prepareMSyukkinboDao();
		// ݃`FbN
		chkDuplicate(getSyukkinboInfo(dto.getKCode(), dto.getHizuke()), vo);
		// f[^̑}
		syukkinboDao.insert(dto);
		// DTO̍Ď擾
		chkInsert(getSyukkinboInfo(dto.getKCode(), dto.getHizuke()));
	}

	/**
	 * \̓o^
	 * @param dto
	 * @throws Exception
	 */
	protected void registSchedule(MScheduleDto dto, VoInterface vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		prepareMScheduleDao();
		MScheduleDto currentDto = getScheduleInfo(dto.getKCode(), dto.getHizuke());
		if (chkExistDto(currentDto)) {
			// rmF
			chkExclusive(currentDto, scheduleDao.findForUpdate(dto.getKCode(), dto.getHizuke()), vo);
			// XV
			scheduleDao.update(dto);
		} else {
			// ݃`FbN
			chkDuplicate(scheduleDao.findForKey(dto.getKCode(), dto.getHizuke()), vo);
			// o^
			scheduleDao.insert(dto);
		}
		// DTO̍Ď擾
		currentDto = scheduleDao.findForKey(dto.getKCode(), dto.getHizuke());		
		chkUpdate(currentDto);
	}

	/**
	 * oΕpݒ
	 * @param dto MScheduleDto
	 * @return mSyukkinboDto MSyukkinboDto
	 * @throws Exception
	 */
	protected MSyukkinboDto copyScheduleInfo(MScheduleDto dto) throws Exception {
		MSyukkinboDto mSyukkinboDto = new MSyukkinboDto();
		mSyukkinboDto.setKCode		(dto.getKCode()		);
		mSyukkinboDto.setHizuke		(dto.getHizuke()	);
		mSyukkinboDto.setNen		(dto.getNen()		);
		mSyukkinboDto.setTuki		(dto.getTuki()		);
		mSyukkinboDto.setHi			(dto.getHi()		);
		mSyukkinboDto.setSyozoku	(dto.getSyozoku()	);
		mSyukkinboDto.setNinsyo		(dto.getNinsyo()	);
		mSyukkinboDto.setSyJikoku	(dto.getSyJikoku()	);
		mSyukkinboDto.setKinmu		(dto.getKinmu()		);
		mSyukkinboDto.setSHankyuKb	(dto.getSHankyuKb()	);
		mSyukkinboDto.setKyusyuKb	(dto.getKyusyuKb()	);
		mSyukkinboDto.setTiRiyuu	(dto.getTiRiyuu()	);
		mSyukkinboDto.setTiComent	(dto.getTiComent()	);
		mSyukkinboDto.setTiSyoumei	(dto.getTiSyoumei()	);
		mSyukkinboDto.setTiJikan	(dto.getTiJikan()	);
		mSyukkinboDto.setSyTimes	(dto.getSyTimes()	);
		mSyukkinboDto.setTaJikoku	(dto.getTaJikoku()	);
		mSyukkinboDto.setKinmuJi	(dto.getKinmuJi()	);
		mSyukkinboDto.setKyukeiJi	(dto.getKyukeiJi()	);
		mSyukkinboDto.setTHankyuKb	(dto.getTHankyuKb()	);
		mSyukkinboDto.setSoRiyuu	(dto.getSoRiyuu()	);
		mSyukkinboDto.setSoComent	(dto.getSoComent()	);
		mSyukkinboDto.setSoSyoumei	(dto.getSoSyoumei()	);
		mSyukkinboDto.setSoJikan	(dto.getSoJikan()	);
		mSyukkinboDto.setZaJikan	(dto.getZaJikan()	);
		mSyukkinboDto.setKsJikan	(dto.getKsJikan()	);
		mSyukkinboDto.setSnJikan	(dto.getSnJikan()	);
		mSyukkinboDto.setSyokuji	(dto.getSyokuji()	);
		mSyukkinboDto.setCyoku1		(dto.getCyoku1()	);
		mSyukkinboDto.setCyoku2		(dto.getCyoku2()	);
		mSyukkinboDto.setCyoku3		(dto.getCyoku3()	);
		mSyukkinboDto.setHoka1		(dto.getHoka1()		);
		mSyukkinboDto.setHoka2		(dto.getHoka2()		);
		mSyukkinboDto.setHoka3		(dto.getHoka3()		);
		mSyukkinboDto.setHoka4		(dto.getHoka4()		);
		mSyukkinboDto.setHoka5		(dto.getHoka5()		);
		mSyukkinboDto.setTaTimes	(dto.getTaTimes()	);
		mSyukkinboDto.setKKRiyuu	(dto.getKKRiyuu()	);
		mSyukkinboDto.setDaiKyuJyu	(dto.getDaiKyuJyu()	);
		mSyukkinboDto.setKKComent	(dto.getKKComent()	);
		mSyukkinboDto.setKKSyoumei	(dto.getKKSyoumei()	);
		mSyukkinboDto.setKKJikan	(dto.getKKJikan()	);
		mSyukkinboDto.setKKTimes	(dto.getKKTimes()	);
		mSyukkinboDto.setSnRiyuu	(dto.getSnRiyuu()	);
		mSyukkinboDto.setSnComent	(dto.getSnComent()	);
		mSyukkinboDto.setSnTimes	(dto.getSnTimes()	);
		mSyukkinboDto.setUpdtTimes	(dto.getUpdtTimes()	);
		return mSyukkinboDto;
	}

	/*ΑӏWv֘A*/

	/**
	 * FL
	 * @param dto ΏDTO
	 * @param targetMonth IN
	 * @return truecFAfalsecFL
	 * @throws Exception
	 */
	protected boolean checkApproval(CompileAmendmentDto dto, Date targetMonth) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		boolean isAllApproved = false;
		// oΕ̎擾Ə
		getAttendanceList(dto.getKCode(), targetMonth);
		// oΕWvf[^擾
		//getAttendanceDaily();
		// FEF쐬
		int[] number = makeApprovalNumber();
		// F
		if (number[1] == 0 && number[2] > 0) {
			isAllApproved = true;
		}
		return isAllApproved;
	}

	/**
	 * ΑӌWv
	 * @param kCode			ΏێЈR[h
	 * @param targetMonth	Ώ۔N
	 * @return	mKintaiDto	WvςDTO
	 * @throws Exception
	 */
	protected MKintaiDto setCompileMonth(String kCode, Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DTȌ
		MKintaiDto mKintaiDto = new MKintaiDto();
		// ϐ錾Aϐ̏
		// ΖԌv
		int totalWork = 0;
		// xeԌv
		int totalInterbal = 0;
		// xԌv
		int totalLate = 0;
		// ގԌv
		int totalLeave = 0;
		// cƎԌv
		int totalOver = 0;
		// xoԌv
		int totalHolidayWork = 0;
		// [鎞Ԍv
		int totalLateNight = 0;
		// oΓv
		double totalWorkDays = 0;
		// oΉ񐔌v
		int totalWorkNumber = 0;
		// Lxv
		double totalPaidHoliday = 0;
		// ʋxɌv
		int totalParticularHoliday = 0;
		// Γv
		int totalAbsence = 0;
		// axɌv
		int totalMedicalLeave = 0;
		// xv
		int totalCompensationDay =0;
		// U֋xɌv
		int totalTransfer = 0;
		// xɌv
		int totalOther = 0;
		// xސ
		int leaveAndLate = 0;
		// 蓖
		int syokuji = 0;
		int cyoku1 = 0;
		int cyoku2 = 0;
		int cyoku3 = 0;
		int hoka1 = 0;
		int hoka2 = 0;
		int hoka3 = 0;
		int hoka4 = 0;
		int hoka5 = 0;
		// 񎞊ԔNx
		int nijikyu = 0;
		// Wvf[^擾
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		// WvJn
		while (it.hasNext()) {
			MSyukkinboDto dto = it.next();
			// ΑӍ
			if (isAvailableWorkType(dto)) {
				// Ζ
				totalWork += dto.getKinmuJi();
				// xe
				totalInterbal += dto.getKyukeiJi();
				// x
				totalLate += dto.getTiJikan();
				// ގ
				totalLeave += dto.getSoJikan();
				// cƎ
				totalOver += dto.getZaJikan();
				// xo
				totalHolidayWork += dto.getKsJikan();
				// [鎞
				totalLateNight += dto.getSnJikan();
				// oΓ
				if (dto.getKinmuJi() > 0) {
					totalWorkDays++;
					totalWorkNumber++;
				}
				// xސ
				if (dto.getTiJikan() > 0 || dto.getSoJikan() > 0) {
					leaveAndLate++;
				}
				// 蓖
				syokuji += dto.getSyokuji();
				cyoku1 += dto.getCyoku1();
				cyoku2 += dto.getCyoku2();
				cyoku3 += dto.getCyoku3();
				hoka1 += dto.getHoka1();
				hoka2 += dto.getHoka2();
				hoka3 += dto.getHoka3();
				hoka4 += dto.getHoka4();
				hoka5 += dto.getHoka5();
				// x
				if (isStartHalfHoliday(dto) || isQuitHalfHoliday(dto)) {
					totalPaidHoliday += 0.5;
					totalWorkDays -= 0.5;
				}
				// 񎞊ԔNx
				nijikyu += dto.getNijiKyu();
			} else {
				// xɍ
				if (!dto.getKKRiyuu().equals("")) {
					if (dto.getKKRiyuu().equals(aryHolidayReason[0][0])) {
						// LxɁim_code, xɗR, tcode="0"j
						totalPaidHoliday++;
					} else if (dto.getKKRiyuu().equals(aryHolidayReason[1][0])) {
						// ʋxɁim_code, xɗR, tcode="1"j
						totalParticularHoliday++;
					} else if (dto.getKKRiyuu().equals(aryHolidayReason[2][0])) {
						// Γim_code, xɗR, tcode="2"j
						totalAbsence++;
					} else if (dto.getKKRiyuu().equals(aryHolidayReason[3][0])) {
						// axɁim_code, xɗR, tcode="3"j
						totalMedicalLeave++;
					} else if (dto.getKKRiyuu().equals(aryHolidayReason[4][0])) {
						// xim_code, xɗR, tcode="4"j
						totalCompensationDay++;
					} else if (dto.getKKRiyuu().equals(aryHolidayReason[5][0])) {
						// U֋xɁim_code, xɗR, tcode="5"j
						totalTransfer++;
					} else {
						// xɁim_code, xɗR, tcode="6"j
						totalOther++;
					}
				}
			}
		}
		// DTOɒlZbg
		mKintaiDto.setKCode(kCode);
		// xN
		mKintaiDto.setSikyuYM(util.convDateToStringYearMonthShort(targetMonth));
		// xN
		mKintaiDto.setSNen(MospUtility.getYear(getCalcPayment()));
		// x
		mKintaiDto.setSTuki(MospUtility.getMonth(getCalcPayment()));
		// x
		mKintaiDto.setSHi(MospUtility.getDay(getCalcPayment()));
		// oΓ
		mKintaiDto.setSNissu(totalWorkDays);
		// oΉ
		mKintaiDto.setSKaisu(totalWorkNumber);
		// Ζԍv
		mKintaiDto.setKinmuJi(totalWork);
		// xeԍv
		mKintaiDto.setKyukeiJi(totalInterbal);
		// Lxɓ
		mKintaiDto.setYukyu(totalPaidHoliday);
		// ʋxɓ
		mKintaiDto.setTokuKyu(totalParticularHoliday);
		// ΋xɓ
		mKintaiDto.setKekkin(totalAbsence);
		// axɓ
		mKintaiDto.setSKekkin(totalMedicalLeave);
		// x
		mKintaiDto.setDaiKyu(totalCompensationDay);
		// U֋xɓ
		mKintaiDto.setFurikae(totalTransfer);
		// xɓ
		mKintaiDto.setSonota(totalOther);
		// xސ
		mKintaiDto.setTiSoKai(leaveAndLate);
		// xގԍv
		mKintaiDto.setTiJikan(totalLate + totalLeave);
		// cƎԍv
		mKintaiDto.setZaJikan(totalOver);
		// xoԍv
		mKintaiDto.setKsJikan(totalHolidayWork);
		// [鎞ԍv
		mKintaiDto.setSnJikan(totalLateNight);
		// F΁i΁AʋxɁAaAxސ̍vj
		if ((totalAbsence + totalParticularHoliday + totalMedicalLeave + leaveAndLate) == 0
				&& totalWorkDays != 0) {
			mKintaiDto.setKaikin(1);
		}
		// Eɂ蓖xݒ
		MYakusyokuDto positionDto = getHoldingPositionInfo(kCode);
		if (chkExistDto(positionDto)) {
			if (positionDto.getKaikin().equals(CommonConst.NAM_COMMON_FLAG_OFF)) {
				mKintaiDto.setKaikin(0);
			}
		}
		// 蓖
		// H蓖v
		mKintaiDto.setSyokujiKaisu(syokuji);
		// P蓖v
		mKintaiDto.setCyokuKaisu1(cyoku1);
		// Q蓖v
		mKintaiDto.setCyokuKaisu2(cyoku2);
		// R蓖v
		mKintaiDto.setCyokuKaisu3(cyoku3);
		// ̑蓖Pv
		mKintaiDto.setHokaKaisu1(hoka1);
		// ̑蓖Qv
		mKintaiDto.setHokaKaisu2(hoka2);
		// ̑蓖Rv
		mKintaiDto.setHokaKaisu3(hoka3);
		// ̑蓖Sv
		mKintaiDto.setHokaKaisu4(hoka4);
		// ̑蓖Tv
		mKintaiDto.setHokaKaisu5(hoka5);
		// 񎞊ԔNxv
		mKintaiDto.setNijiKyu(nijikyu);
		return mKintaiDto;
	}

	/**
	 * Ζp^[z擾
	 * @param rotationCode
	 * @return	aryRotaiton	Ζp^[z
	 * @throws Exception
	 */
	protected String[] getRotationArray(String rotationCode) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		CmRotationDao cmRotationDao = new CmRotationDao();
		cmRotationDao.initDao(cfg, cmd, aspUser, user, conn);
		CmRotationDto dto = cmRotationDao.findForKey(mKihon.getKCode(), rotationCode);
		String[] aryRotaiton = new String[10];
		if (chkExistDto(dto)) {
			aryRotaiton[0] = dto.getDay1();
			aryRotaiton[1] = dto.getDay2();
			aryRotaiton[2] = dto.getDay3();
			aryRotaiton[3] = dto.getDay4();
			aryRotaiton[4] = dto.getDay5();
			aryRotaiton[5] = dto.getDay6();
			aryRotaiton[6] = dto.getDay7();
			aryRotaiton[7] = dto.getDay8();
			aryRotaiton[8] = dto.getDay9();
			aryRotaiton[9] = dto.getDay10();
		} else {
			aryRotaiton = new String[0];
		}
		return aryRotaiton;
	}

	/**
	 * jՓtO擾
	 * @param rotationCode
	 * @return 0cfalseA1ctrue
	 * @throws Exception
	 */
	protected boolean getPublicHolidayFlag(String rotationCode) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		CmRotationDao cmRotationDao = new CmRotationDao();
		cmRotationDao.initDao(cfg, cmd, aspUser, user, conn);
		CmRotationDto dto = cmRotationDao.findForKey(mKihon.getKCode(), rotationCode);
		if (chkExistDto(dto) && dto.getHolidayFlag() != 0) {
			return true;
		}
		return false;
	}

	/*ΑӏF֘A*/

	/**
	 * ΑӏF
	 * @param kcode			Ώێ
	 * @param targetDate	Ώ۔N
	 * @param reason		FR
	 * @param comment		FRg
	 * @param approver		F
	 * @throws Exception
	 */
	protected void runApprovalProcess(
			String kcode,
			String targetDate,
			String reason,
			String comment,
			String approver
	) throws Exception {
		// ̎擾
		MSyukkinboDto dto = getSyukkinboInfo(kcode, targetDate, true);
		// rmF
		chkExist(dto);
		// Fݒ
		dto.setNinsyo(approver);
		dto.setSnRiyuu(reason);
		dto.setSnComent(comment);
		dto.setSnTimes(util.getDateTime(util.getNowDate()));
		dto.setUpdtTimes(util.getDateTime(util.getNowDate()));
		// F
		syukkinboDao.update(dto);
		// DTO̍Ď擾
		chkUpdate(getSyukkinboInfo(dto.getKCode(), dto.getHizuke()));
	}

	/**
	 * oΕ\tO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * \ȂtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean isRequest(String snriyuu) {
		return snriyuu.equals(getApprovalStatusCodeArray()[0]) ? true : false;
	}

	/**
	 * oΕ\tO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * \ȂtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean isRequest(MSyukkinboDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return isRequest(dto.getSnRiyuu());
		}
		return false;
	}

	/**
	 * oΕꎟFσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean is1stApproved(String snriyuu) {
		return snriyuu.equals(getApprovalStatusCodeArray()[1]) ? true : false;
	}

	/**
	 * oΕꎟFσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	protected boolean is1stApproved(MSyukkinboDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return is1stApproved(dto.getSnRiyuu());
		}
		return false;
	}

	/**
	 * oΕ񎟏FσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean is2ndApproved(String snriyuu) {
		return snriyuu.equals(getApprovalStatusCodeArray()[3])? true: false;
	}

	/**
	 * oΕ񎟏FσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	protected boolean is2ndApproved(MSyukkinboDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return is2ndApproved(dto.getSnRiyuu());
		}
		return false;
	}

	/**
	 * oΕ돳FσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	protected boolean isApproved(MSyukkinboDto dto) throws Exception {
		if (chkExistDto(dto)) {
			if (is1stApproved(dto) || is2ndApproved(dto)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * xof
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param code		Ώې\
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean isWorkOnHoliday(String code) {
		return code.equals(CommonConst.NUM_WORK_ON_HOLIDAY_FLAG_ON) ? true : false;
	}

	/**
	 * xof
	 * <p>	2009/04/21	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	protected boolean isWorkOnHoliday(MScheduleDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return isWorkOnHoliday(dto.getKyusyuKb());
		}
		return false;
	}

	/**
	 * xof
	 * <p>	2009/04/21	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	protected boolean isWorkOnHoliday(MSyukkinboDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return isWorkOnHoliday(dto.getKyusyuKb());
		}
		return false;
	}

	/**
	 * Oxf
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param code		Ώې\
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean isStartHalfHoliday(String code) {
		return code.equals(CommonConst.NUM_START_HALF_HOLIDAY_FLAG_ON) ? true : false;
	}

	/**
	 * Oxf
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	protected boolean isStartHalfHoliday(MScheduleDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return isStartHalfHoliday(dto.getSHankyuKb());
		}
		return false;
	}

	/**
	 * Oxf
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	protected boolean isStartHalfHoliday(MSyukkinboDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return isStartHalfHoliday(dto.getSHankyuKb());
		}
		return false;
	}

	/**
	 * 㔼xf
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param code		Ώې\
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean isQuitHalfHoliday(String code) {
		return code.equals(CommonConst.NUM_QUIT_HALF_HOLIDAY_FLAG_ON) ? true : false;
	}

	/**
	 * 㔼xf
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	protected boolean isQuitHalfHoliday(MScheduleDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return isQuitHalfHoliday(dto.getTHankyuKb());
		}
		return false;
	}

	/**
	 * 㔼xf
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	protected boolean isQuitHalfHoliday(MSyukkinboDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return isQuitHalfHoliday(dto.getTHankyuKb());
		}
		return false;
	}

	/**
	 * xɁANxftO
	 * <p>	2009/04/21	m.yoshida	ǉ		</p>
	 * @param kinmu			ΏۋΖ`ԃR[h
	 * @return
	 * <p>
	 * xɁANxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean isHoliday(String kinmu) {
		return kinmu.equals(CommonConst.ATTENDANCE_TYPE_HOLIDAY);
	}

	/**
	 * xɁANxftO
	 * <p>	2009/04/21	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * \낪xɁANxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean isHoliday(MScheduleDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return isHoliday(dto.getKinmu());
		}
		return false;
	}

	/**
	 * xɁANxftO
	 * <p>	2009/04/21	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * oΕ낪xɁANxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean isHoliday(MSyukkinboDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return isHoliday(dto.getKinmu());
		}
		return false;
	}

	/**
	 * TxftO
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kinmu			ΏۋΖ`ԃR[h
	 * @return
	 * <p>
	 * TxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean isWeekHoliday(String kinmu) {
		return kinmu.equals(CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
	}

	/**
	 * TxftO
	 * <p>	2009/04/21	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * \낪TxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean isWeekHoliday(MScheduleDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return isWeekHoliday(dto.getKinmu());
		}
		return false;
	}

	/**
	 * TxftO
	 * <p>	2009/04/21	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * \낪TxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	protected boolean isWeekHoliday(MSyukkinboDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return isWeekHoliday(dto.getKinmu());
		}
		return false;
	}

	/**
	 * Ζ\ftO
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param dto			ΏDTO
	 * @return
	 * <p>
	 * Ζ\ȋΖ`Ԃ̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	protected boolean isAvailableWorkType(MScheduleDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return !isHoliday(dto) 	&& !isWeekHoliday(dto);
		}
		return false;
	}

	/**
	 * Ζ\ftO
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param dto			ΏDTO
	 * @return
	 * <p>
	 * Ζ\ȋΖ`Ԃ̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	protected boolean isAvailableWorkType(MSyukkinboDto dto) throws Exception {
		if (chkExistDto(dto)) {
			return !isHoliday(dto) && !isWeekHoliday(dto);
		}
		return false;
	}

	/**
	 * J}؂̓t擾
	 * @param year		
	 * @param month
	 * @param day
	 * @return
	 */
	protected String getMessageDate(String year, String month, String day) {
		return util.convStringDateFormatted(year, month, day);
	}

}
